package loader;

import org.antlr.v4.runtime.*;

import java.util.Arrays;
import java.util.List;

public class TestParser {
    public static void main(String[] args) {
        List<String> testCases = Arrays.asList(
                "JOIN([$r, $s], [[a], [f(X),Y], [Y]], [X,Y,Z])",
                "ANTIJOIN ([$r, $r], [[a, Y], [Y, Z]], [X, Y, Z])",
                "UNION ([$r, $r])",
                "REC(p, UNION ([$r, JOIN ([$r, p], [[Y, X], [Y]], [X])]))",
                //p(X) :- r(X, Y), p(Y).
                "REC(p, JOIN([$r, p],[[X,Y],[Y]],[X]))",
                //p(X) :- r(X, Y), p(Y).
                //?p(7)
                "JOIN([REC(p, JOIN([$r, p],[[X,Y],[Y]],[X]))],[[7]], [7])"
        );

        for (String inputString : testCases) {
            System.out.println("\nTesting input: " + inputString);
            testVisitor(inputString);

        }

    }

    public static void testVisitor(String input){
        CharStream inputStream = CharStreams.fromString(input);
        relationalAlgebraLexer operatorLexer = new relationalAlgebraLexer(inputStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(operatorLexer);
        relationalAlgebraParser operatorParser = new relationalAlgebraParser(commonTokenStream);
        relationalAlgebraParser.QueryContext queryContext = operatorParser.query();
        relationalAlgebraBaseVisitor<Object> visitor = new relationalAlgebraBaseVisitor<>();
        System.out.println("Query object: " + visitor.visitQuery(queryContext));
    }
}
